<?php
// Include your database connection
include("db.php");

// Start the session
session_start();

// Set content type to JSON
header('Content-Type: application/json');

// Enable error reporting for debugging
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Get POST parameters
$product_id = $_POST['id'] ?? ''; // Product ID passed from request

// Check if product_id is provided
if (empty($product_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Product ID is required']);
    exit();
}

// Step 1: Fetch all variant_product_id from product_variants table for the given product_id
$variantQuery = "SELECT variant_product_id FROM product_variants WHERE Product_id = '$product_id'";
$variantResult = $conn->query($variantQuery);

if ($variantResult && $variantResult->num_rows > 0) {
    $variant_product_ids = [];
    while ($variantRow = $variantResult->fetch_assoc()) {
        $variant_product_ids[] = $variantRow['variant_product_id'];
    }

    // Step 2: Fetch products that match these variant_product_ids
    $variant_product_ids_str = implode("','", $variant_product_ids); // Convert array to comma-separated string
    $sql = "SELECT 
               p.Product_id, 
               p.Product_name, 
               p.SKU, 
               p.Selling_price, 
               p.Purchase_price,
               p.MRP, 
               p.qty, 
               p.Product_image, 
               p.variant_id, 
               p.qty,
               p.mode
            FROM product p
            WHERE p.Product_id IN ('$variant_product_ids_str') AND p.Delete_status = 0";

    $result = $conn->query($sql);

    // Prepare the response
    if ($result && $result->num_rows > 0) {
        $products = [];
        while ($row = $result->fetch_assoc()) {
            $variantCount = !empty($row['variant_id']) ? count(explode(',', $row['variant_id'])) : 0;
            $products[] = [
                'id' => $row['Product_id'],
                'productname' => $row['Product_name'],
                'sku' => $row['SKU'],
                'saleprice' => $row['Selling_price'],
                'purchaseprice' => $row['Purchase_price'],
                'mrp' => $row['MRP'],
                'qty' => $row['qty'] ?: '0', // Default to 0 if qty is empty
                'productimg' => $row['Product_image'],
                'qty'=> $row['qty'],
                'Variant' => $variantCount,
                'mode' => $row['mode']
            ];
        }
        echo json_encode(['status' => 'success', 'data' => $products]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'No products found for the given variants']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'No variants found for the given product ID']);
}
?>